/*
 * Decompiled with CFR 0.152.
 */
package net.sovex.sovexconnectionlockvc;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.sovex.shaded.gson.Gson;
import net.sovex.shaded.gson.JsonObject;
import net.sovex.shaded.okhttp3.MediaType;
import net.sovex.shaded.okhttp3.OkHttpClient;
import net.sovex.shaded.okhttp3.Request;
import net.sovex.shaded.okhttp3.RequestBody;
import net.sovex.shaded.okhttp3.Response;
import net.sovex.sovexconnectionlockvc.PluginConfig;
import org.slf4j.Logger;

public class ConnectionStatusService {
    private final OkHttpClient httpClient;
    private final Gson gson;
    private final Logger logger;
    private final PluginConfig config;

    public ConnectionStatusService(Logger logger, PluginConfig config) {
        this.logger = logger;
        this.config = config;
        this.gson = new Gson();
        this.httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();
    }

    public CompletableFuture<Boolean> sendPlayerJoin(String playerName, String playerUuid) {
        return this.sendStatusUpdate(playerName, playerUuid, "join");
    }

    public CompletableFuture<Boolean> sendPlayerLeave(String playerName, String playerUuid) {
        return this.sendStatusUpdate(playerName, playerUuid, "quit");
    }

    private CompletableFuture<Boolean> sendStatusUpdate(String playerName, String playerUuid, String action) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (this.config.isDebugMode()) {
                    this.logger.info("[DEBUG] Sending {} status for player: {} (UUID: {})", new Object[]{action, playerName, playerUuid});
                }
                JsonObject jsonData = new JsonObject();
                jsonData.addProperty("player_name", playerName);
                jsonData.addProperty("player_uuid", playerUuid);
                jsonData.addProperty("action", action);
                jsonData.addProperty("timestamp", System.currentTimeMillis());
                String jsonString = this.gson.toJson(jsonData);
                if (this.config.isDebugMode()) {
                    this.logger.info("[DEBUG] Request JSON: {}", (Object)jsonString);
                }
                RequestBody body = RequestBody.create(jsonString, MediaType.get("application/json; charset=utf-8"));
                Request.Builder requestBuilder = new Request.Builder().url("https://api.sovex.net/v2/launcherConnectStatus.php").post(body).addHeader("Content-Type", "application/json").addHeader("User-Agent", "SovexConnectionLockVC/1.0").addHeader("Authorization", this.config.getAuthorizationKey()).addHeader("Server", this.config.getServerIp()).addHeader("Username", playerName).addHeader("Type", action);
                Request request = requestBuilder.build();
                if (this.config.isDebugMode()) {
                    this.logger.info("[DEBUG] Request headers: Authorization={}, Server={}, Username={}, Type={}", new Object[]{this.config.getAuthorizationKey(), this.config.getServerIp(), playerName, action});
                }
                try (Response response = this.httpClient.newCall(request).execute();){
                    if (response.isSuccessful()) {
                        if (this.config.isDebugMode()) {
                            this.logger.info("[DEBUG] Successfully sent {} status for player: {}. Response: {}", new Object[]{action, playerName, response.body() != null ? response.body().string() : "No response body"});
                        } else {
                            this.logger.info("Successfully sent {} status for player: {}", (Object)action, (Object)playerName);
                        }
                        Boolean bl = true;
                        return bl;
                    }
                    this.logger.warn("Failed to send {} status for player: {}. Response code: {}", new Object[]{action, playerName, response.code()});
                    if (this.config.isDebugMode() && response.body() != null) {
                        this.logger.info("[DEBUG] Error response body: {}", (Object)response.body().string());
                    }
                    Boolean bl = false;
                    return bl;
                }
            }
            catch (IOException e) {
                this.logger.error("Error sending {} status for player: {}", new Object[]{action, playerName, e});
                return false;
            }
        });
    }

    public void shutdown() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }
}

