/*
 * Decompiled with CFR 0.152.
 */
package net.sovex.sovexconnectionlockvc;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.proxy.Player;
import java.util.concurrent.CompletableFuture;
import net.sovex.sovexconnectionlockvc.ConnectionStatusService;
import org.slf4j.Logger;

public class PlayerConnectionListener {
    private final ConnectionStatusService connectionStatusService;
    private final Logger logger;

    public PlayerConnectionListener(ConnectionStatusService connectionStatusService, Logger logger) {
        this.connectionStatusService = connectionStatusService;
        this.logger = logger;
    }

    @Subscribe
    public void onPlayerJoin(PostLoginEvent event) {
        Player player = event.getPlayer();
        String playerName = player.getUsername();
        String playerUuid = player.getUniqueId().toString();
        this.logger.info("Player {} joined the server", (Object)playerName);
        ((CompletableFuture)this.connectionStatusService.sendPlayerJoin(playerName, playerUuid).thenAccept(success -> {
            if (success.booleanValue()) {
                this.logger.debug("Successfully sent join status for player: {}", (Object)playerName);
            } else {
                this.logger.warn("Failed to send join status for player: {}", (Object)playerName);
            }
        })).exceptionally(throwable -> {
            this.logger.error("Exception occurred while sending join status for player: {}", (Object)playerName, throwable);
            return null;
        });
    }

    @Subscribe
    public void onPlayerLeave(DisconnectEvent event) {
        Player player = event.getPlayer();
        String playerName = player.getUsername();
        String playerUuid = player.getUniqueId().toString();
        this.logger.info("Player {} left the server", (Object)playerName);
        ((CompletableFuture)this.connectionStatusService.sendPlayerLeave(playerName, playerUuid).thenAccept(success -> {
            if (success.booleanValue()) {
                this.logger.debug("Successfully sent leave status for player: {}", (Object)playerName);
            } else {
                this.logger.warn("Failed to send leave status for player: {}", (Object)playerName);
            }
        })).exceptionally(throwable -> {
            this.logger.error("Exception occurred while sending leave status for player: {}", (Object)playerName, throwable);
            return null;
        });
    }
}

