/*
 * Decompiled with CFR 0.152.
 */
package net.sovex.sovexconnectionlockvc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.sovex.shaded.gson.Gson;
import net.sovex.shaded.gson.GsonBuilder;
import net.sovex.shaded.gson.JsonObject;
import net.sovex.shaded.gson.JsonParser;
import org.slf4j.Logger;

public class PluginConfig {
    private String authorizationKey;
    private String serverIp;
    private boolean debugMode;
    private final Path configPath;
    private final Gson gson;
    private final Logger logger;

    public PluginConfig(Path dataDirectory, Logger logger) {
        this.logger = logger;
        this.configPath = dataDirectory.resolve("sovexconnectionlockvc.json");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.loadConfig();
    }

    private void loadConfig() {
        block7: {
            try {
                if (this.configPath.getParent() != null) {
                    Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
                }
                if (Files.exists(this.configPath, new LinkOption[0])) {
                    String content = Files.readString(this.configPath, StandardCharsets.UTF_8);
                    JsonObject json = JsonParser.parseString(content).getAsJsonObject();
                    this.authorizationKey = json.has("authorization_key") ? json.get("authorization_key").getAsString() : "YOUR_AUTHORIZATION_KEY_HERE";
                    this.serverIp = json.has("server_ip") ? json.get("server_ip").getAsString() : "YOUR_SERVER_IP_HERE";
                    boolean bl = this.debugMode = json.has("debug_mode") ? json.get("debug_mode").getAsBoolean() : false;
                    if (this.logger != null) {
                        String maskedAuth = this.authorizationKey == null ? "null" : (this.authorizationKey.length() <= 4 ? "****" : this.authorizationKey.substring(0, 2) + "****" + this.authorizationKey.substring(this.authorizationKey.length() - 2));
                        this.logger.info("Loaded config from: {} (debug_mode={}, server_ip={}, authorization={})", new Object[]{this.configPath.toAbsolutePath(), this.debugMode, this.serverIp, maskedAuth});
                    }
                } else {
                    this.authorizationKey = "YOUR_AUTHORIZATION_KEY_HERE";
                    this.serverIp = "YOUR_SERVER_IP_HERE";
                    this.debugMode = false;
                    this.createDefaultConfig();
                    if (this.logger != null) {
                        this.logger.info("Generated default config at: {}", (Object)this.configPath.toAbsolutePath());
                    }
                }
            }
            catch (Exception e) {
                this.authorizationKey = "YOUR_AUTHORIZATION_KEY_HERE";
                this.serverIp = "YOUR_SERVER_IP_HERE";
                this.debugMode = false;
                if (this.logger == null) break block7;
                this.logger.error("Failed to load config, using defaults", (Throwable)e);
            }
        }
    }

    private void createDefaultConfig() {
        block2: {
            try {
                JsonObject config = new JsonObject();
                config.addProperty("authorization_key", "YOUR_AUTHORIZATION_KEY_HERE");
                config.addProperty("server_ip", "YOUR_SERVER_IP_HERE");
                config.addProperty("debug_mode", false);
                String jsonString = this.gson.toJson(config);
                Files.writeString(this.configPath, (CharSequence)jsonString, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                if (this.logger == null) break block2;
                this.logger.error("Could not create default config at {}", (Object)this.configPath.toAbsolutePath(), (Object)e);
            }
        }
    }

    public void saveConfig() {
        block2: {
            try {
                JsonObject config = new JsonObject();
                config.addProperty("authorization_key", this.authorizationKey);
                config.addProperty("server_ip", this.serverIp);
                config.addProperty("debug_mode", this.debugMode);
                String jsonString = this.gson.toJson(config);
                Files.writeString(this.configPath, (CharSequence)jsonString, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                if (this.logger == null) break block2;
                this.logger.error("Could not save config at {}", (Object)this.configPath.toAbsolutePath(), (Object)e);
            }
        }
    }

    public String getAuthorizationKey() {
        return this.authorizationKey;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setAuthorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }
}

