/*
 * Decompiled with CFR 0.152.
 */
package net.sovex.sovexconnectionlockvc;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import net.sovex.sovexconnectionlockvc.ConnectionStatusService;
import net.sovex.sovexconnectionlockvc.PlayerConnectionListener;
import net.sovex.sovexconnectionlockvc.PluginConfig;
import org.slf4j.Logger;

@Plugin(id="sovexconnectionlockvc", name="SovexConnectionLockVC", version="1.0-SNAPSHOT", description="Sovex Launchers", url="https://sovex.net/", authors={"Metehan Salman", "Sovex"})
public class SovexConnectionLockVC {
    @Inject
    private Logger logger;
    @Inject
    private ProxyServer proxyServer;
    @Inject
    @DataDirectory
    private Path dataDirectory;
    private PluginConfig config;
    private ConnectionStatusService connectionStatusService;
    private PlayerConnectionListener playerConnectionListener;

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.logger.info("SovexConnectionLockVC plugin is starting...");
        try {
            this.config = new PluginConfig(this.dataDirectory, this.logger);
            this.logger.info("Configuration loaded successfully from {}", (Object)this.dataDirectory.resolve("sovexconnectionlockvc.json").toAbsolutePath());
            if ("YOUR_AUTHORIZATION_KEY_HERE".equals(this.config.getAuthorizationKey())) {
                this.logger.warn("Please configure your authorization key in the config file!");
            }
            if ("YOUR_SERVER_IP_HERE".equals(this.config.getServerIp())) {
                this.logger.warn("Please configure your server IP in the config file!");
            }
            if (this.config.isDebugMode()) {
                this.logger.info("Debug mode is enabled");
            }
            this.connectionStatusService = new ConnectionStatusService(this.logger, this.config);
            this.playerConnectionListener = new PlayerConnectionListener(this.connectionStatusService, this.logger);
            this.proxyServer.getEventManager().register((Object)this, (Object)this.playerConnectionListener);
            this.logger.info("SovexConnectionLockVC plugin has been enabled successfully!");
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize SovexConnectionLockVC plugin", (Throwable)e);
        }
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.logger.info("SovexConnectionLockVC plugin is shutting down...");
        if (this.connectionStatusService != null) {
            this.connectionStatusService.shutdown();
        }
        if (this.config != null) {
            this.config.saveConfig();
        }
        this.logger.info("SovexConnectionLockVC plugin has been disabled!");
    }

    public PluginConfig getConfig() {
        return this.config;
    }
}

